var expireTime = document.querySelector('#expire-time');

// Set the date we're counting down to
var countDownDate = new Date(expireTime.dataset.expire).getTime();

// alert(countDownDate)

// Update the count down every 1 second
var x = setInterval(function () {

    // Get today's date and time
    var now = new Date().getTime();

    // Find the distance between now and the count down date
    var distance = countDownDate - now;

    // Time calculations for days, hours, minutes and seconds
    var days = Math.floor(distance / (1000 * 60 * 60 * 24));
    var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
    var seconds = Math.floor((distance % (1000 * 60)) / 1000);

    var daysTxt = days > 0 ? days + "يوم ": '';
    var hoursTxt = hours > 0 ? hours + "ساعة ": '';
    var minutesTxt =minutes > 0 ? minutes + "دقيقة ": '';
    var secondsTxt =seconds > 0 ? seconds + "ثانية ": '';
        // Display the result in the element with id="demo"
        expireTime.title = 'المتبقي من وقت الاختبار ' + daysTxt + hoursTxt +
        minutesTxt + secondsTxt;

    // If the count down is finished, write some text
    if (distance < 0) {
        clearInterval(x);
        expireTime.title = "انتهى وقت الاختبار";
    }
}, 1000);